/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.McfKeyword;
import com.ibm.hwmca.fw.util.Trace;

public class MCFLine {
    private static final String TRACE_MASKT = "XMCFlinT";
    private static final String TRACE_MASKF = "XMCFlinF";
    private static final String TRACE_MASKD = "XMCFlinD";
    static final int NO_ACTION = 0;
    static final int ADD_FILE = 1;
    static final int ERASE_FILE = 2;
    static final int REPLACE_FILE = 3;
    static final int EXECUTE_ON_ACTIVATE = 4;
    static final int EXECUTE_ON_DEACTIVATE = 5;
    static final int EXECUTE_RPM = 6;
    static final int SET_PATH = 7;
    static final int FORCE_REBOOT = 8;
    static final int APPLY_NOW = 9;
    static final int AUTOMATICALLY_ACCEPT = 10;
    static final int ERASE_MCF = 11;
    static final int HEXPATCH_FILE = 12;
    static final int COMPONENT_KEYWORD = 13;
    static final int EC_EQUALS = 14;
    static final int CALLBACK_KEYWORD = 15;
    static final int INVALID_KEYWORD = 255;
    int command = 255;
    String name = "";
    String suffix = "";
    private boolean securityInfoExists = false;
    private String owner = null;
    private String group = null;
    private String permissions = null;
    private boolean linkInfoExists = false;
    private String linkTargetFileName = null;
    private String linkType = null;
    private McfKeyword keyword = null;

    MCFLine(String commandAsString, String name, String suffix) {
        Trace.trace(TRACE_MASKT, "-> MCFLine(String, String, String)");
        this.command = MCFLine.convertMcfCommand(commandAsString);
        this.name = name;
        if (null == name) {
            this.name = "";
        }
        this.suffix = suffix;
        if (null == suffix) {
            this.suffix = "";
        }
        Trace.trace(TRACE_MASKT, "<- MCFLine(String, String, String) - command value is " + this.command + ", name is [" + this.name + "], suffix is [" + this.suffix + "]");
    }

    MCFLine(String commandAsString, String name) {
        this(commandAsString, name, "");
        Trace.trace(TRACE_MASKT, "<> MCFLine(String, String)");
    }

    public MCFLine(McfKeyword keyword) {
        Trace.trace(TRACE_MASKT, "-> MCFLine(McfKeyword)");
        if (null == keyword) {
            this.command = 255;
        } else {
            this.command = 15;
            this.keyword = keyword;
        }
        Trace.trace(TRACE_MASKT, "<- MCFLine(Keyword) - keyword value is [" + this.keyword + "]");
    }

    static int convertMcfCommand(String commandAsString) {
        Trace.trace(TRACE_MASKT, "-> MCFLine.convertMcfCommand() - command string is [" + commandAsString + "]");
        commandAsString = commandAsString.toUpperCase();
        int command = commandAsString.equals("ACCEPT") ? 10 : (commandAsString.equals("AEXEC") ? 4 : (commandAsString.equals("ADD") ? 1 : (commandAsString.equals("AFILE") ? 1 : (commandAsString.equals("APPLY_NOW") ? 9 : (commandAsString.equals("COMPONENT") ? 13 : (commandAsString.equals("DEXEC") ? 5 : (commandAsString.startsWith("DISRUPTIVE") ? 0 : (commandAsString.equals("EDC_REQ") ? 0 : (commandAsString.equals("EFILE") ? 2 : (commandAsString.equals("EMCF") ? 11 : (commandAsString.equals("ERASE") ? 2 : (commandAsString.equals("FORCE_SP_REBOOT") ? 8 : (commandAsString.equals("HFILE") ? 12 : (commandAsString.equals("NONDISRUPTIVE") ? 0 : (commandAsString.equals("PATH") ? 7 : (commandAsString.equals("REPLACE") ? 3 : (commandAsString.equals("RPM") ? 6 : (commandAsString.equals("UPDATE (HEX-DIFF)") ? 12 : (commandAsString.equals("RFILE") ? 3 : (commandAsString.equals("RPM") ? 6 : (commandAsString.equals("VOLUME") ? 0 : (commandAsString.equals("EC") ? 14 : 255))))))))))))))))))))));
        Trace.trace(TRACE_MASKT, "<- MCFLine.convertMcfCommand() - command value is " + command);
        return command;
    }

    public void setLinkTargetFileName(String newLinkTargetFileName) {
        this.linkTargetFileName = newLinkTargetFileName;
        this.linkInfoExists = true;
    }

    public void setLinkType(String newLinkType) {
        this.linkType = newLinkType;
        this.linkInfoExists = true;
    }

    public void setGroup(String newGroup) {
        this.group = newGroup;
        if (null == this.group) {
            this.group = "";
        }
        this.securityInfoExists = true;
    }

    public String getGroup() {
        return this.group;
    }

    public McfKeyword getKeyword() {
        return this.keyword;
    }

    public void setOwner(String newOwner) {
        this.owner = newOwner;
        if (null == this.owner) {
            this.owner = "";
        }
        this.securityInfoExists = true;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setPermissions(String newPermissions) {
        this.permissions = newPermissions;
        if (null == this.permissions) {
            this.permissions = "";
        }
        this.securityInfoExists = true;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public boolean securityInfoExists() {
        return this.securityInfoExists;
    }

    public int getCommand() {
        Trace.trace(TRACE_MASKD, "<> getCommand returns " + this.command + ".");
        return this.command;
    }

    public String getName() {
        return this.name;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        String s = "[" + this.command + "], [" + this.name + "], [" + this.suffix + "]";
        if (this.securityInfoExists) {
            s = s + ", security info is [" + this.owner + ", " + this.group + ", " + this.permissions + "]";
        }
        if (this.linkInfoExists) {
            s = s + ", link info is [" + this.linkTargetFileName + ", " + this.linkType + "]";
        }
        return s;
    }
}

